/**
 * @file: adit_ssy.h
 *
 * @version: $Id: adit_ssy.h,v 1.24 2011/03/26 13:15:12 smaleyka Exp $
 *
 * This header file defines Subsystem IDs for ADIT-Platform.
 *
 * @component: global definition file
 *
 * @author: N.Arakawa (DT; ADITJ/SWG) <narakawa@jp.adit-jv.com>
 *
 * @copyright: (c) 2003  2004 ADIT Corporation
 *
 */

#ifndef ADIT_SSY_H
#define ADIT_SSY_H

/**
 * Base Values for the eSOL T-Kernel Subsystems
 */
#define TKERNEL_SSYID_BASE  0x00
#define TKERNEL_SSYID_END   0x31

#define DMA_SVC                       (TKERNEL_SSYID_END - 0)

#define NEL_IEEE1394CORE_SSYID        (TKERNEL_SSYID_END - 15)
#define NEL_USBHCORE_SSYID            (TKERNEL_SSYID_END - 16)
#define NEL_USBFGENERIC_CONTROL_SSYID (TKERNEL_SSYID_END - 17)
#define NEL_USBFSTORAGE_CONTROL_SSYID (TKERNEL_SSYID_END - 18)
#define NEL_EVM_SSYID                 (TKERNEL_SSYID_END - 19)

/**
 * Base Values for the ADIT-Platform Subsystems
 */
#define ADIT_SSYID_BASE     0x32    /* 0x32 .. 0x63 =  50 possible subsystems */

#define SQLITE_SVC          (ADIT_SSYID_BASE + 0)

/*
            (ADIT_SSYID_BASE + 1)
            (ADIT_SSYID_BASE + 2)
            (ADIT_SSYID_BASE + 3)
            (ADIT_SSYID_BASE + 4)
            (ADIT_SSYID_BASE + 5)
            (ADIT_SSYID_BASE + 6)
            (ADIT_SSYID_BASE + 7)
*/

#define SVG_CON_SVC         (ADIT_SSYID_BASE + 8)
#define SVG_LAY_SVC         (ADIT_SSYID_BASE + 9)
#define SVG_RSC_SVC         (ADIT_SSYID_BASE + 10)
#define SVG_RST_SVC         (ADIT_SSYID_BASE + 11)

#define SYSCALL_SVC         (ADIT_SSYID_BASE + 12)
#define RPC_SSY_SVC         (ADIT_SSYID_BASE + 13)

/** Kasago */ 
#define KA_SVC              (ADIT_SSYID_BASE + 14)
#define KA_PRI              8

#define SVG_VIDEO_SVC       (ADIT_SSYID_BASE + 15)

/*
                            (ADIT_SSYID_BASE + 16) 
*/

#define SVG_BDC_SVC         (ADIT_SSYID_BASE + 17)

/** CAL */
#define SSYCAL_SVC          (ADIT_SSYID_BASE + 18)

/*
            (ADIT_SSYID_BASE + 19)
            (ADIT_SSYID_BASE + 20)
            (ADIT_SSYID_BASE + 21)
*/

#define SVG_ANIM_SVC        (ADIT_SSYID_BASE + 22) /** used in svg_animation */

/*
            (ADIT_SSYID_BASE + 23)
*/

/** TFW */
#define SSYTFW_SVC          (ADIT_SSYID_BASE + 24)
#define SSYIMGCMP_SVC       (ADIT_SSYID_BASE + 25)

/*
            (ADIT_SSYID_BASE + 26)
            (ADIT_SSYID_BASE + 27)
*/

#define UTIL_SVC            (ADIT_SSYID_BASE + 28) 
#define CAL_RSM_SVC         (ADIT_SSYID_BASE + 29)

/*
            (ADIT_SSYID_BASE + 30)
            (ADIT_SSYID_BASE + 31)
            (ADIT_SSYID_BASE + 32)
*/

/** DCF */
#define DCF_SVC             (ADIT_SSYID_BASE + 33)

/** IPOD Control */
#define IPOD_SVC            (ADIT_SSYID_BASE + 34)

/** SED */
#define SED_SVC             (ADIT_SSYID_BASE + 35)
#define CMP_SYS_TST_SVC     (ADIT_SSYID_BASE + 36)
#define SGXSRV_SVC          (ADIT_SSYID_BASE + 37)
#define SSYPC_SVC           (ADIT_SSYID_BASE + 38)
#define SSYRESDETECT_SVC    (ADIT_SSYID_BASE + 39)
#define SSYDEMO_SVC         (ADIT_SSYID_BASE + 40)

/** Streammanager */
#define STM_SVC             (ADIT_SSYID_BASE + 41)

/** FilterGraph */
#define FG_SVC              (ADIT_SSYID_BASE + 42)

/** SVG bitmap decoder */
#define SVG_BMPDEC_SVC      (ADIT_SSYID_BASE + 43)

/** XML Parser */
#define XML_SVC             (ADIT_SSYID_BASE + 44)

/** Mpeg decoder */
#define VMPEG2_SVC          (ADIT_SSYID_BASE + 45)
#define VMP_SVC             (ADIT_SSYID_BASE + 46)

/** Trace */
#define TRACE_SVC           (ADIT_SSYID_BASE + 47)

/** USBF */
#define USBF_SVC            (ADIT_SSYID_BASE + 48)

/** USBF_TDD */
#define USBF_TDD_SVC        (ADIT_SSYID_BASE + 49)

/** Attention 50 and greater numbers are reserved for MC */

/**
 * Base Values for the MC Subsystems
 */
#define MC_SSYID_BASE       0x64 /* 0x64 .. 0xFF = 155 possible subsystems */


#endif /* ADIT_SSY_H */
